/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.model;

import com.adobe.granite.workflow.HasMetaData;

/**
 * <code>WorkflowTransition</code> represents a transition between two
 * <code>{@link WorkflowNode}</code>s of a <code>{@link WorkflowModel}</code>.
 */
public interface WorkflowTransition extends HasMetaData {
	/**
	 * Returns the <code>{@link WorkflowNode}</code> that is the source of
	 * this <code>WorkflowTransition</code>.
	 * 
	 * @return The <code>{@link WorkflowNode}</code> that is the source of
	 *         this <code>WorkflowTransition</code>.
	 */
	WorkflowNode getFrom();

	/**
	 * Sets the <code>{@link WorkflowNode}</code> that is the source of this
	 * <code>WorkflowTransition</code>.
	 * 
	 * @param from
	 *            The <code>{@link WorkflowNode}</code> that is the source of
	 *            this <code>WorkflowTransition</code>.
	 */
	void setFrom(WorkflowNode from);

	/**
	 * Returns the <code>{@link WorkflowNode}</code> that is the target of
	 * this <code>WorkflowTransition</code>.
	 * 
	 * @return The <code>{@link WorkflowNode}</code> that is the target of
	 *         this <code>WorkflowTransition</code>.
	 */
	WorkflowNode getTo();

	/**
	 * Sets the <code>{@link WorkflowNode}</code> that is the target of this
	 * <code>WorkflowTransition</code>.
	 * 
	 * @param to
	 *            The <code>{@link WorkflowNode}</code> that is the target of
	 *            this <code>WorkflowTransition</code>.
	 */
	void setTo(WorkflowNode to);

	/**
	 * Returns the rule that defines if this <code>WorkflowTransition</code>
	 * can be followed or not.
	 * 
	 * @return The execution rule of the <code>WorkflowTransition</code>.
	 */
	String getRule();

	/**
	 * Sets the rules that defines if this <code>WorkflowTransition</code> can
	 * be followed or not.
	 * 
	 * @param rule
	 *            The execution rule of the <code>WorkflowTransition</code>.
	 */
	void setRule(String rule);
}
