/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa.content;

import com.adobe.xfa.Element;
import com.adobe.xfa.Int;
import com.adobe.xfa.Node;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.XFA;

/**
 * A class that represents the <text> content element in XFA schemas.
 *
 * @exclude from published api.
 */
public final class TextValue extends Content {
	public TextValue(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.TEXT, XFA.TEXT,
				null, XFA.TEXTTAG, XFA.TEXT);
	}

	public boolean equals(Object object) {
		
		if (this == object)
			return true;
		
		return super.equals(object) &&
			getValue().equals(((TextValue) object).getValue());
	}
	
	public int hashCode() {
		return super.hashCode() ^ getValue().hashCode();
	}

	/**
	 * @exclude from published api.
	 */
	public ScriptTable getScriptTable() {
		return TextScript.getScriptTable();
	}

	/**
	 * Get the text stored in this element
	 * 
	 * @return the text string truncated to maxChars
	 */
	public String getValue() {
		String string = getStrValue();
        if (string != null) {
    		Int maxChars = (Int) getAttribute(XFA.MAXCHARSTAG);
    		// If necessary, truncate the string to maxChars.
    		int max = maxChars.toInt();
    		if (0 < max && max < string.length())
    			string = string.substring(0, max);
		}
		return string;
	}

	/**
	 * Set the text value within this element
	 * 
	 * @param sText
	 *            a string to set/replace the text stored in this element
	 */
	public void setValue(String sText) {
		super.setStrValue(sText, true, false);
	}
}
