package com.day.cq.search.suggest;

import aQute.bnd.annotation.ConsumerType;

/**
 * Interface for building the internal index path for a given term. The
 * {@link SuggestionIndexManager} will use this service interface for the
 * {@link SuggestionIndex}es. A default path builder is provided.
 * 
 * <p>
 * Note that implementations must be thread-safe.
 */
@ConsumerType
public interface PathBuilder {
    
    /**
     * Returns a relative path for the given term.
     * 
     * @param term the term to build the path for
     * @return a relative repository path
     */
    String buildTermPath(String term);
}