/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.foundation;

import java.util.Iterator;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import com.day.cq.wcm.foundation.impl.WCMRenditionPickerConfig;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

/**
 * The <code>WCMRenditionPicker</code> searches first the web rendition starting
 * with <code>"cq5dam.web."</code>. If no web rendition exists the current original
 * is returned.
 */
public class WCMRenditionPicker implements RenditionPicker {
    private static final String WEB_RENDITION_PREFIX = "cq5dam.web.";

    public Rendition getRendition(Asset asset) {
        int defaultRenditionWidth = 1280;
        Bundle bundle = FrameworkUtil.getBundle(WCMRenditionPicker.class);
        if (bundle != null) {
            BundleContext bundleContext = bundle.getBundleContext();
            ServiceReference<?> serviceRef = bundleContext.getServiceReference(WCMRenditionPickerConfig.class.getName());
            WCMRenditionPickerConfig renditionPickerConfig = (WCMRenditionPickerConfig) bundleContext.getService(serviceRef);
            if (renditionPickerConfig != null) {
                defaultRenditionWidth = renditionPickerConfig.getDefaultRenditionWidth();
            }
        }

        final String defaultRenditionPrefix = WEB_RENDITION_PREFIX + defaultRenditionWidth;

        Iterator<Rendition> renditions = asset.listRenditions();
        Rendition webRenditionFallback = null;

        while(renditions.hasNext()) {
            Rendition rendition = renditions.next();
            if (rendition.getName().startsWith(defaultRenditionPrefix)) {
                return rendition;
            }
            if (webRenditionFallback == null && rendition.getName().startsWith(WEB_RENDITION_PREFIX)) {
                webRenditionFallback = rendition;
            }
        }

        if (webRenditionFallback != null) {
            return webRenditionFallback;
        }

        return asset.getOriginal();
    }
}
