/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.tags;

import static com.day.cq.wcm.tags.DefineObjectsTag.*;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.VariableInfo;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.wcm.api.policies.ContentPolicy;
import org.apache.sling.api.resource.ValueMap;

import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.EditContext;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;

/**
 * Tag extra info of the {@link DefineObjectsTag}.
 */
public class DefineObjectsTEI extends org.apache.sling.scripting.jsp.taglib.DefineObjectsTEI {

    public static final String ATTR_COMPONENT_CONTEXT_NAME = "componentContextName";
    public static final String ATTR_EDIT_CONTEXT_NAME = "editContextName";
    public static final String ATTR_PROPERTIES_NAME = "propertiesName";
    public static final String ATTR_PAGE_MANAGER_NAME = "pageManagerName";
    public static final String ATTR_CURRENT_PAGE_NAME = "currentPageName";
    public static final String ATTR_RESOURCE_PAGE_NAME = "resourcePageName";
    public static final String ATTR_PAGE_PROPERTIES_NAME = "pagePropertiesName";
    public static final String ATTR_COMPONENT_NAME = "componentName";
    public static final String ATTR_DESIGNER_NAME = "designerName";
    public static final String ATTR_CURRENT_DESIGN_NAME = "currentDesignName";
    public static final String ATTR_RESOURCE_DESIGN_NAME = "resourceDesignName";
    public static final String ATTR_CURRENT_STYLE_NAME = "currentStyleName";
	public static final String ATTR_XSSAPI_NAME = "xssAPIName";
	public static final String ATTR_CURRENT_POLICY_NAME = "currentPolicyName";
    public static final String ATTR_CURRENT_POLICY_PROPS_NAME = "currentPolicyPropertiesName";

    private static final String COMPONENT_CONTEXT_CLASS = ComponentContext.class.getName();
    private static final String EDIT_CONTEXT_CLASS = EditContext.class.getName();
    private static final String PROPERTIES_CLASS = ValueMap.class.getName();
    private static final String PAGE_MANAGER_CLASS = PageManager.class.getName();
    private static final String CURRENT_PAGE_CLASS = Page.class.getName();
    private static final String RESOURCE_PAGE_CLASS = Page.class.getName();
    private static final String PAGE_PROPERTIES_CLASS = InheritanceValueMap.class.getName();
    private static final String COMPONENT_CLASS = Component.class.getName();
    private static final String DESIGNER_CLASS = Designer.class.getName();
    private static final String CURRENT_DESIGN_CLASS = Design.class.getName();
    private static final String RESOURCE_DESIGN_CLASS = Design.class.getName();
    private static final String CURRENT_STYLE_CLASS = Style.class.getName();
	private static final String XSSAPI_CLASS = XSSAPI.class.getName();
	private static final String CURRENT_POLICY_CLASS = ContentPolicy.class.getName();
	private static final String CURRENT_POLICY_PROPS_CLASS = ValueMap.class.getName();

    public VariableInfo[] getVariableInfo(TagData data) {
        List<VariableInfo> varInfos = new ArrayList<VariableInfo>();
        varInfos.addAll(Arrays.asList(super.getVariableInfo(data)));

        addVar(varInfos, data, ATTR_COMPONENT_CONTEXT_NAME, DEFAULT_COMPONENT_CONTEXT_NAME, COMPONENT_CONTEXT_CLASS);
        addVar(varInfos, data, ATTR_EDIT_CONTEXT_NAME, DEFAULT_EDIT_CONTEXT_NAME, EDIT_CONTEXT_CLASS);
        addVar(varInfos, data, ATTR_PROPERTIES_NAME, DEFAULT_PROPERTIES_NAME, PROPERTIES_CLASS);
        addVar(varInfos, data, ATTR_PAGE_MANAGER_NAME, DEFAULT_PAGE_MANAGER_NAME, PAGE_MANAGER_CLASS);
        addVar(varInfos, data, ATTR_CURRENT_PAGE_NAME, DEFAULT_CURRENT_PAGE_NAME, CURRENT_PAGE_CLASS);
        addVar(varInfos, data, ATTR_RESOURCE_PAGE_NAME, DEFAULT_RESOURCE_PAGE_NAME, RESOURCE_PAGE_CLASS);
        addVar(varInfos, data, ATTR_PAGE_PROPERTIES_NAME, DEFAULT_PAGE_PROPERTIES_NAME, PAGE_PROPERTIES_CLASS);
        addVar(varInfos, data, ATTR_COMPONENT_NAME, DEFAULT_COMPONENT_NAME, COMPONENT_CLASS);
        addVar(varInfos, data, ATTR_DESIGNER_NAME, DEFAULT_DESIGNER_NAME, DESIGNER_CLASS);
        addVar(varInfos, data, ATTR_CURRENT_DESIGN_NAME, DEFAULT_CURRENT_DESIGN_NAME, CURRENT_DESIGN_CLASS);
        addVar(varInfos, data, ATTR_RESOURCE_DESIGN_NAME, DEFAULT_RESOURCE_DESIGN_NAME, RESOURCE_DESIGN_CLASS);
        addVar(varInfos, data, ATTR_CURRENT_STYLE_NAME, DEFAULT_CURRENT_STYLE_NAME, CURRENT_STYLE_CLASS);
		addVar(varInfos, data, ATTR_XSSAPI_NAME, DEFAULT_XSSAPI_NAME, XSSAPI_CLASS);
		addVar(varInfos, data, ATTR_CURRENT_POLICY_NAME, DEFAULT_CURRENT_CONTENT_POLICY_NAME, CURRENT_POLICY_CLASS);
		addVar(varInfos, data, ATTR_CURRENT_POLICY_PROPS_NAME, DEFAULT_CURRENT_CONTENT_POLICY_PROPS_NAME, CURRENT_POLICY_PROPS_CLASS);

        return varInfos.toArray(new VariableInfo[varInfos.size()]);
    }

    private void addVar(List<VariableInfo> varInfos, TagData data,
            String attrName, String defaultValue, String varClass) {
        String value = getValue(data, attrName, defaultValue);

        if (value != null && varClass != null) {
            varInfos.add(new VariableInfo(value, varClass, true,
                VariableInfo.AT_END));
        }
    }

    private String getValue(TagData data, String name, String defaultValue) {
        Object value = data.getAttribute(name);
        if (value instanceof String) {
            return (String) value;
        }

        return defaultValue;
    }

}