/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2021 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.aem.wcm.seo.sitemap;

import org.osgi.annotation.versioning.ConsumerType;

import com.day.cq.wcm.api.Page;

/**
 * This interface is filter that can be implemented by consumers to exclude certain pages from a sitemap.
 * <p>
 * {@link SitemapPageFilter#shouldInclude(Page)} can be used to exclude individual {@link Page}s from all sitemaps and
 * {@link SitemapPageFilter#shouldFollow(Page)} to stop the traversal at a given {@link Page}. However, both methods only complement the
 * default behaviour. {@link Page}s that are unpublished, protected, redirect or marked not to be indexed by search engines, will remain
 * excluded from all sitemaps.
 * <p>
 * If there are multiple {@link SitemapPageFilter} services registered, the one with the highest service ranking will be used.
 */
@ConsumerType
public interface SitemapPageFilter {

    /**
     * Implementations may return {@code false} to exclude the given {@link Page} from all sitemaps.
     *
     * @param page the given {@link Page} to check
     * @return {@code false} to exclude the {@link Page} from all sitemaps, {@code true} otherwise
     */
    boolean shouldInclude(Page page);

    /**
     * Implementations may return {@code false} to exclude the given subtree from all sitemaps.
     *
     * @param page the given subtree's root {@link Page} to check
     * @return {@code false} to exclude the subtree from all sitemaps, {@code true} otherwise
     */
    boolean shouldFollow(Page page);

}
