/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2021 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any.  The
 * intellectual and technical concepts contained herein are
 * proprietary to Adobe and its suppliers and are protected
 * by all applicable intellectual property laws, including
 * trade secret and copyright laws.  Dissemination of this
 * information or reproduction of this material is strictly
 * forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.aem.wcm.seo.sitemap.externalizer;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ConsumerType;

/**
 * This service interface is an extension of the {@link org.apache.sling.sitemap.spi.common.SitemapLinkExternalizer} that provides an
 * additional method to externalize any path in the same way {@link org.apache.sling.sitemap.spi.common.SitemapLinkExternalizer#externalize(org.apache.sling.api.resource.Resource)}
 * works.
 */
@ConsumerType
public interface SitemapLinkExternalizer extends org.apache.sling.sitemap.spi.common.SitemapLinkExternalizer {

    /**
     * {@inheritDoc}
     */
    @Override
    @NotNull
    String externalize(SlingHttpServletRequest request, String path);

    /**
     * {@inheritDoc}
     */
    @Override
    @NotNull
    String externalize(Resource resource);

    /**
     * Returns an absolute url for the given path. This path may include an extension, suffix or query string.
     *
     * @param resourceResolver
     * @param path
     * @return the absolute url
     * @throws IllegalArgumentException is thrown then the given string is not a path
     */
    @NotNull
    String externalize(ResourceResolver resourceResolver, String path);

}
