/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2019 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package com.adobe.cq.adobeims.imsprofile;

import java.util.List;

import javax.annotation.Nonnull;

/**
 * The <code>ImsProfileService</code> integrates the IMS Profile API.
 */
public interface ImsProfileService {

    /**
     * @param imsProfileKey an {@link ImsProfileKey} object containing the data to identify the right ims config
     * @return a list of {@link ImsProfileProdCtx} objects or an empty list if no data is available
     * @throws ImsProfileException {@link ImsProfileException} if something went wrong when requesting the IMS Profile API
     * @throws InvalidImsConfigException {@link InvalidImsConfigException} if the IMS config is invalid
     */
    List<ImsProfileProdCtx> getImsProfileProdCtxs(@Nonnull ImsProfileKey imsProfileKey);
}
