/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.contentinsight;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.annotation.versioning.ProviderType;

/**
 * A service for accessing Content Insight provider settings for
 * resources, e.g. pages.
 */
@ProviderType
public interface ProviderSettingsManager {

    /**
     * Returns a map of providers each containing a map of settings for the
     * given resource.
     * 
     * @param res The resource for which to get provider settings.
     * @return Map of providers containig each a map of settings for the
     *         specified resource.
     */
    public ValueMap getProviderSettings(Resource res);
    
    /**
     * Checks whether active providers are available for the given resource.
     * 
     * @param res The resource for which to check providers.
     * @return {@code true} if active providers are available, {@code false}
     *         otherwise.
     */
    public boolean hasActiveProviders(Resource res);
}
