/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.adobe.cq.dam.cfm;

import aQute.bnd.annotation.ProviderType;

import java.util.Iterator;

/**
 * Implementations of this class provide access to the meta data definition of a template.
 */
@ProviderType
public interface MetaDataDefinition {

    /**
     * Gets an iterator on the meta data properties that are available.
     *
     * @return Iterator on meta data properties
     */
    Iterator<MetaDataProperty> getMetaDataProperties();

    /**
     * Gets a meta data property by the specified name.
     *
     * @param name The name of the meta data property
     * @return The meta data property; <code>null</code> if no such property exists
     */
    MetaDataProperty getMetaDataPropertyByName(String name);

}
