/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/***
 * <p>Provides an extensible framework for converting text formats (like plain text,
 * Markdown) into an HTML representation that can be used within an AEM page.</p>
 *
 * <p>It also provides means to convert a text from one format into another format. For
 * this, the text has to be converted to HTML in the first place, then into the target
 * format.</p>
 *
 * <h3>Basic usage:</h3>
 *
 * <p>To convert a text of a certain MIME type to HTML, use
 * {@link com.adobe.cq.dam.cfm.converter.ContentTypeConverter#convertToHTML}.</p>
 *
 * <p>To convert a text of MIME type A to MIME type B, use something like:</p>
 *
 * <code>
 * String html = typeConverter.convertToHTML(textA, typeA);<br>
 * String textB = typeConverter.convertToType(html, typeB);
 * </code>
 */
@Version("1.0.0")
package com.adobe.cq.dam.cfm.converter;

import org.osgi.annotation.versioning.Version;