/*
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2020 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */

package com.adobe.cq.dam.download.api;

import java.net.URI;
import java.util.Map;
import java.util.Optional;

import org.osgi.annotation.versioning.ProviderType;

import com.adobe.cq.dam.download.spi.DownloadTargetProcessor;

/**
 * <p>
 * Factory interface for creating various objects whose implementations depend
 * on the type of service being implemented.
 * </p>
 * <p>
 * Implementers of custom {@link DownloadService} implementations should implement
 * this interface to return dependencies whose types are applicable to the
 * custom service.
 * </p>
 * @see DownloadService
 * @see DownloadManifest
 * @see DownloadFile
 * @see DownloadTarget
 */
@ProviderType
public interface DownloadApiFactory {

    /**
     * Creates a new manifest instance for use with the {@link DownloadService}.
     * @return An empty manifest.
     */
    DownloadManifest createDownloadManifest();

    /**
     * Creates a new instance for use with a {@link DownloadTargetProcessor}.
     * @param size The size, in bytes, of the file.
     * @param binaryURI URI to the file's binary data.
     * @param parameters Additional data to include with the file.
     * @return An initialized instance that uses the provided values.
     */
    DownloadFile createDownloadFile(Optional<Long> size, URI binaryURI, Map<String, Object> parameters);
    
    /**
     * Creates a representation of a failed download file.
     * @param failureReason The reason this download file should be considered failed.
     * @param parameters Additional data to include with the file.
     * @return An initialized instance that uses the provided values.
     */
    DownloadFile createFailedDownloadFile(String failureReason, Map<String, Object> parameters);

    /**
     * Creates a new instance for use with a {@link DownloadManifest}.
     * @param targetType The target's {@link DownloadTarget#getType()} value.
     * @param parameters Parameters to be retrieved using the target's getParameter() methods.
     * @return An initialized target instance that uses the provided values.
     */
    DownloadTarget createDownloadTarget(String targetType, Map<String, Object> parameters);
}
