/*
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2021 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
package com.adobe.cq.dam.download.spi;

import java.net.URI;

import com.adobe.cq.dam.archive.api.ArchiveBinary;
import com.adobe.cq.dam.archive.api.AsyncArchiveProgressService;
import com.adobe.cq.dam.download.api.DownloadArtifact;
import com.adobe.cq.dam.download.api.DownloadProgress;
import com.adobe.cq.dam.download.api.DownloadStorageService;
import com.adobe.cq.dam.download.impl.servlet.DownloadServlet;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.annotation.versioning.ConsumerType;

/**
 * This interface provides entry points for consumers to add custom processing of download artifacts.
 */
@ConsumerType
public interface DownloadArtifactPostProcessor {

    /**
     * <p>
     * Entry point for custom processing of download artifacts.  Implementing will prevent wait for download
     * functionality in {@link DownloadServlet}.
     * </p>
     * <p>
     * This method is called as part of the {@link AsyncArchiveProgressService#setArchiveBinary(String, String, ArchiveBinary)},
     * upon successfully setting the archive binary.
     * </p>
     *
     * @param downloadId Unique identifier for the download.
     * @param progress   Can be used by the post processor to get information about the download.
     * @param artifact   Item whose parameters can be used by the processor to retrieve binary information.
     * @param binary     The archive binary.
     * @return Value indicates whether the download artifact was handled.
     */
    boolean processDownloadArtifact(String downloadId, DownloadProgress progress, DownloadArtifact artifact, DownloadArtifactBinary binary);

    /**
     * <p>
     * Entry point for custom purging of download artifacts.
     * </p>
     * <p>
     * This method is called as part of {@link DownloadStorageService#purgeDownload(String, ResourceResolver)},
     * upon successfully purging the archive binary.
     * </p>
     *
     * @param downloadId Unique identifier for the download.
     * @return Value indicates whether the download artifact was handled.
     */
    boolean purgeDownload(String downloadId);

    /**
     * This interface provides download artifact details required for post processing.
     */
    public interface DownloadArtifactBinary {

        /**
         * Returns a URI for downloading this binary directly from the storage location.
         *
         * @return A URI for downloading the binary directly, or null if the binary cannot be downloaded
         * directly or if the underlying implementation does not support this capability.
         */
        URI getUri();

        /**
         * Returns the size of this Binary value in bytes.
         *
         * @return The size of this value in bytes.
         */
        long getSize();

    }

}