/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/
package com.adobe.cq.dam.mac.sync.helper;

import java.util.Map;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.annotation.versioning.ProviderType;

import com.adobe.cq.dam.mac.sync.api.SyncAgent;

/**
 * Mac Sync Helper, provides utility methods
 */
@ProviderType
public interface MacSyncHelper {
    /**
     * Get List of CC Users
     * @param currentResource current resource
     * @return Map of CC users, email to full user name
     */
    Map<String, String> getCCUsers(Resource currentResource);

    /**
     * Returns whether the current user can sync a folder with MAC
     * @param resourceResolver user resource resolver
     * @param path the path of resource
     *
     * @return whether the current user can sync a folder with MAC
     */
    boolean canSync(ResourceResolver resourceResolver, String path);

    /**
     * Each replication agent which uses OAuth server to server authentication should be bound to a specific
     * access token provider. This method sets the access token provider pid as a property on the replication agent.
     * @param macSyncAgent the DAM Sync Agent
     * @param rr Resource resolver
     * @param macConfiguration mac configuration
     * @param pid The pid of the access token provider
     */
    void updateReplicationAgentProviderPid(SyncAgent macSyncAgent, ResourceResolver rr, MACTenantConfiguration macConfiguration, String pid);
}
