/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.gfx;

import java.util.List;

import aQute.bnd.annotation.ProviderType;

/**
 * Describes graphics rendering operations with multiple layers.
 *
 * <p>
 * A plan has the following structure, in order of execution:
 * <ul>
 *     <li>multiple layers (0..N) with individual commands (higher layers are merged onto lower layers)</li>
 *     <li>composition (layer commands applied after layers have been merged)</li>
 *     <li>view commands (define resulting image and file format)</li>
 * </ul>
 *
 * Both the view and the layers implement the {@link Instructions map-like interface}
 * in which instructions are set in a key-value style with keys being strings.
 */
@ProviderType
public interface Plan {

    /**
     * Instruction regarding the output view of the rendering plan.
     * Defines the output image format and other global flags.
     *
     * @return map containing view related instructions
     */
    Instructions view();

    /**
     * Retrieve layers from 0 (lowest) to N (highest). The layer asked for
     * and all yet missing layers in between will be added on the fly.
     *
     * @param index index of the layer to retrieve
     * @return the layer at the given index, will be created if it does not exist yet
     */
    Layer layer(int index);

    /**
     * All layers of the plan.
     *
     * @return a modifiable list of all layers in the plan
     */
    List<Layer> layers();

    /**
     * Returns the special composition layer. These are layer commands executed after
     * all layers have been merged and before the output image is serialized.
     *
     * @return the special composition layer
     */
    Layer composition();

    /**
     * Returns a single-line string representation of this plan for log and debug output.
     *
     * @return a single-line string representation of this plan
     */
    String toString();

    /**
     * Returns a multi-line JSON representation of this plan.
     *
     * @return a multi-line JSON representation of this plan
     */
    String toJsonString();
}
