/*
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2019 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
package com.adobe.cq.inbox.api.preferences;

import com.adobe.cq.inbox.api.InboxException;
import com.adobe.cq.inbox.api.preferences.domain.InboxPreferences;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.annotation.versioning.ProviderType;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Interface for the setting and getting AEM Inbox Preferences
 */
@ProviderType
public interface InboxPreferencesProvider {

    /**
     * Returns the {@link InboxPreferences} of the user
     * or empty object if Inbox Prefernces is not present
     * @param resolver The caller's {@link ResourceResolver}
     * @return The {@link InboxPreferences} of the user
     * @throws InboxException {@link InboxException}
     */
    @Nonnull InboxPreferences getPreferences(@Nonnull ResourceResolver resolver) throws InboxException;

    /**
     * Sets the {@link InboxPreferences} of the user
     * or null if you want to remove inbox preferences
     * @param resolver The caller's {@link ResourceResolver}
     * @param preferences The {@link InboxPreferences} of the user
     * @throws InboxException {@link InboxException}
     */
    void setPreferences(@Nonnull ResourceResolver resolver, @Nullable InboxPreferences preferences) throws InboxException;
}
