/*
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2019 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
package com.adobe.cq.inbox.api.preferences.domain;

import com.adobe.cq.inbox.api.preferences.domain.outofoffice.OutOfOfficePreferences;
import com.adobe.cq.inbox.api.preferences.domain.share.SharingPreferences;
import com.adobe.cq.inbox.api.preferences.domain.view.ViewPreferences;
import org.osgi.annotation.versioning.ProviderType;

import javax.annotation.Nonnull;

/**
 * Interface for the AEM Inbox Preferences
 */
@ProviderType
public interface InboxPreferences {

    /**
     * Returns the {@link ViewPreferences}
     * or empty object if view preferences is not present
     * @return The {@link ViewPreferences}
     */
    @Nonnull ViewPreferences getViewPreferences();

    /**
     * Returns the {@link SharingPreferences}
     * or empty object if sharing preferences is not present
     * @return The {@link SharingPreferences}
     */
    @Nonnull SharingPreferences getSharingPreferences();

    /**
     * Returns the {@link OutOfOfficePreferences}
     * or empty object if out of office preferences is not present
     * @return The {@link OutOfOfficePreferences}
     */
    @Nonnull OutOfOfficePreferences getOutOfOfficePreferences();

}
