/*
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2019 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
package com.adobe.cq.inbox.api.preferences.domain.outofoffice;

import org.osgi.annotation.versioning.ProviderType;

/**
 * Interface for the AEM Inbox Out Of Office Date Range
 */
@ProviderType
public interface OutOfOfficeDateRange {

    /**
     * Returns the start time for out of office range
     * @return The start time for out of office range
     */
    long getStartTime();

    /**
     * Sets the start time for out of office range
     * @param startTime start time for out of office range
     */
    void setStartTime(long startTime);

    /**
     * Returns the end time for out of office range
     * @return The end time for out of office range
     */
    long getEndTime();

    /**
     * Sets the end time for out of office range
     * @param endTime the end time for out of office range
     */
    void setEndTime(long endTime);
}
