/*
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2019 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
package com.adobe.cq.inbox.api.preferences.domain.share;

import org.osgi.annotation.versioning.ProviderType;

import javax.annotation.Nonnull;
import java.util.Map;
import java.util.Set;

/**
 * Interface for the AEM Inbox Sharing Preferences
 */
@ProviderType
public interface SharingPreferences {

    /**
     * Return the set of users with whom user has shared her inbox
     * or empty set if users are not present
     * @return set containing user id(s)
     */
    @Nonnull Set<String> getSharesInboxWith();

    /**
     * Return the set of users who rejected current user's inbox access request
     * or empty set if users are not present
     * @return set containing user id(s)
     */
    @Nonnull Set<String> getRejectedRequests();

    /**
     * Returns the map of user id's and respective workflow instance id's for those users on whom the inbox access request is pending
     * or empty Map if user id's and respective workflow instance id's are not present
     * @return The Map of user ids' and respective workflow instance ids' for those users on whom the inbox access request is pending
     */
    @Nonnull Map<String, String> getPendingRequestMap();
}
