/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
/**
 * AdobePatentID="3435US01"
 */
package com.adobe.cq.launches.api;

/**
 * Launch promotion scope.
 */
public enum LaunchPromotionScope {
    /**
     * Promote full launch
     */
    FULL,
    /**
     * Promote all changed resources in the launch
     */
    SMART,
    /**
     * Promote resource
     */
    RESOURCE,
    /**
     * Promote resource and all its children
     */
    DEEP,
    /**
     * Promotes full launch with approved pages
     */
    APPROVED;

    /**
     * Get the launch promotion scope value
     *
     * @return The launch promotion scope value
     */
    public String getValue() {
        return this.name().toLowerCase();
    }
}
