package com.adobe.cq.mcm.campaign.profile;

import com.day.cq.mcm.campaign.ACConnectorException;
import org.apache.sling.api.resource.Resource;

/**
 * <p>Retrieves the Campaign meta data for a page.</p>
 *
 * <p>Contrary to {@link com.day.cq.mcm.campaign.profile.MetaDataRetriever}, this class
 * creates a tree hierarchy with a flexible depth.</p>
 */
public interface MetaDataRetriever {

    /**
     * Retrieves the meta data for the specified page resource.
     *
     * @param page The page resource
     * @return The root node of the meta data
     * @throws ACConnectorException if the data could not be retrieved due to a problem
     *                              with the connector service
     */
    MetaDataNode retrieve(Resource page) throws ACConnectorException;

}
