/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.msm.ui.models.alllivecopies;


import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LiveCopiesRow {
    private String rowPath;
    private String rowTitle;
    private List<LiveCopiesCell> cells;
    private Map<String, String> rowAttrs;


    private boolean isPage;

    private String thumbnailPath;

    private String actionRels;

    private String relPath;

    public LiveCopiesRow(String resourcePath, String resourceName, String relPath) {
        this.isPage = false;
        this.cells = Collections.<LiveCopiesCell>emptyList();
        this.rowPath = resourcePath;
        this.rowTitle = resourceName;
        this.rowAttrs = setRowAttributes(rowPath);
        this.thumbnailPath = "";
        this.actionRels = "";
        this.relPath = relPath;


    }

    public LiveCopiesRow(Boolean isPage, String rowPath, String rowTitle, List<LiveCopiesCell> cells, String thumbnailPath, String actionRels, String relPath) {
        this.isPage = isPage;
        this.cells = cells;
        this.rowPath = rowPath;
        this.rowTitle = rowTitle;
        this.rowAttrs = setRowAttributes(rowPath);
        this.thumbnailPath = thumbnailPath;
        this.actionRels = actionRels;
        this.relPath = relPath;
    }

    public boolean isPage() {
        return isPage;
    }

    public String getRowPath() {
        return rowPath;
    }

    public String getRowTitle() {
        return rowTitle;
    }

    public List<LiveCopiesCell> getCells() {
        return cells;
    }

    public Map<String, String> getRowAttrs() {
        return rowAttrs;
    }

    public String getThumbnailPath() {
        if (isPage) {
            return thumbnailPath;
        }
        return null;
    }

    public String getActionRels() {
        return actionRels;
    }

    public String getRelPath() {
        return relPath;
    }

    public boolean isRolloutHierarchicalResource() {
        return isPage;
    }

    private Map<String, String> setRowAttributes(String rowPath) {
        Map<String, String> rowAttrs = new HashMap<String, String>();
        rowAttrs.put("is", "coral-table-row");
        rowAttrs.put("data-foundation-collection-item-id", rowPath);
        if (isRolloutHierarchicalResource()) {
            rowAttrs.put("selectable", "selectable");
        }
        rowAttrs.put("data-path", rowPath);
        return rowAttrs;
    }




}
