/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.projects.api;

import java.util.List;

/**
 * used to filter projects in {@link ProjectManager}
 */
public class ProjectFilter {

    private Boolean active = null;
    private List<String> projectTemplates = null;

    /**
     * indicates if active projects are to be returned
     * @return true when active projects are to be returned
     */
    public Boolean getActive() {
        return active;
    }

    /**
     * indicate whether active or inactive projects are to be returned.  by not providing a value both inactive and active projects will be returned
     * @param active set whether to return active or inactive projects
     */
    public void setActive(Boolean active) {
        this.active = active;
    }

    /**
     * Indicates if projects list should be restricted to provided list of project templates
     * @return List of project templates the list should be restricted to
     */
    public List<String> getProjectTemplates() {
        return projectTemplates;
    }

    /**
     * Defines the list of project templates the list should be restricted to
     * @param projectTemplates List of project templates the list should be restricted to, or <code>null</code> if it shouldn't be filtered
     */
    public void setProjectTemplates(List<String> projectTemplates) {
        this.projectTemplates = projectTemplates;
    }

}
