/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.scheduled.exporter;

import org.apache.sling.api.resource.Resource;

/**
 * A <code>Transformer</code> is used to transform a {@link Resource} to a
 * certain type <code>T</code>.
 * 
 * @param <T> Transformer type
 */
public interface Transformer<T> {

    /**
     * Transforms a {@link Resource} into another representation of type
     * <code>T</code>.
     * 
     * @param resource Resource to transform
     * @return Transformed Resource of type T or <code>null</code> if Resource
     *         is not transformable into this type.
     * @throws TransformationException if transformation fails
     */
    T transform(Resource resource) throws TransformationException;

}
