/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/
package com.adobe.cq.sites.ui.models.admin.security;

import com.adobe.granite.ui.components.Value;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.RequestAttribute;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

/**
 * Representation of the Closed User Group configuration that is persisted on the repository for a given content resource.
 *
 * This is used in order to know if the CUG configuration is deprecated (usage of cq:cug* properties) and thus disable the editing of the CUGs in such case.
 *
 * The content resource is derived from the content path attribute of the request.
 */
@Model(adaptables = SlingHttpServletRequest.class)
public final class CUGConfig {
    @Self
    private SlingHttpServletRequest slingRequest;

    @Inject
    @SlingObject
    private Resource resource;

    @Inject
    private ResourceResolver resolver;

    @RequestAttribute(optional = true, name = Value.CONTENTPATH_ATTRIBUTE)
    private String contentPath;

    @ValueMapValue(optional = true, name = "warning")
    private String warning;

    private boolean isDeprecated = false;

    @PostConstruct
    protected void initModel() throws RepositoryException {
        if (contentPath != null) {
            Resource contentResource = resolver.getResource(contentPath);

            if (contentResource != null) {
                Node node = contentResource.adaptTo(Node.class); // Node is the jcr:content node
                isDeprecated = node.getProperties("cq:cug*").hasNext();
            }
        }
    }

    /**
     * Indicates if the content resource is using a deprecated Closed User Group configuration
     * @return
     */
    public boolean isDeprecated() {
        return isDeprecated;
    }

    /**
     * Returns the warning message telling the user that the content resource is using a deprecated Closed User Group configuration
     * @return
     */
    public String getWarning() { return warning; }
}

