/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.adobe.cq.smartcontent;

import org.osgi.annotation.versioning.ProviderType;

import java.util.Locale;

/**
 * <p>This interface represents implementation-specific language data.</p>
 *
 * <p>Typically, it contains references to dictionaries, language models, etc.</p>
 */
@ProviderType
public interface LanguageData {

    /**
     * <p>Get the locale of the language data.</p>
     *
     * <p>Note that the returned locale represents the actual locale of the data, which
     * may be different to the one specified for
     * {@link SmartContentAuthoringService#getLanguageData(Locale)}, as there are resolution
     * strategies in place if the initial locale is too specific.</p>
     *
     * @return The locale the language data is representing
     */
    Locale getLocale();

}
