package com.adobe.cq.targetrecommendations.api.model;

import org.osgi.annotation.versioning.ProviderType;

/**
 * Abstraction of a Target Recommendation Template
 */
@ProviderType
public interface RecommendationTemplate extends RecommendationsEntity {
    
    /**
     * Uniquely identifies a recommendation template
     * 
     * @return a {@link Integer} value identifying this {@code RecommendationTemplate}
     */
    public int getId();

    /**
     * Get the name of this {@code RecommendationTemplate}
     * 
     * @return a {@link String} object containing this template's name
     */
    public String getName();
    
    /**
     * Get the actual script content of this template. <br>
     * Must be a valid Velocity script
     * 
     * @return a {@link StringBuilder} containing the template script content
     */
    public String getScript();
}
