/*
 * ************************************************************************
 *  *
 *  * ADOBE CONFIDENTIAL
 *  * __________________
 *  *
 *  *  Copyright 2023 Adobe Incorporated
 *  *  All Rights Reserved.
 *  *
 *  * NOTICE:  All information contained herein is, and remains
 *  * the property of Adobe Incorporated and its suppliers,
 *  * if any.  The intellectual and technical concepts contained
 *  * herein are proprietary to Adobe Incorporated and its
 *  * suppliers and are protected by trade secret or copyright law.
 *  * Dissemination of this information or reproduction of this material
 *  * is strictly forbidden unless prior written permission is obtained
 *  * from Adobe Incorporated.
 *  *************************************************************************
 */
package com.adobe.cq.wcm.launches.cf;

import com.adobe.cq.launches.api.LaunchPromotionParameters;

import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

/**
 * This class contains parameters needed when performing a launch operation.
 */
@ProviderType
public interface ContentFragmentLaunchOperationParameters extends LaunchPromotionParameters {

    /**
     * Whether the operation should be deep or not.
     * @return Boolean value of isDeep
     */
    boolean isDeep();

    /**
     * List of source Content Fragments to be included in the specific operation of the Launch.
     * @return List of source Content Fragments
     */
    List<String> getSourceCFList();

    /**
     * Another launch path to compare to if not performing the operation against main content.
     * @return Another launch path
     */
    String getLaunchPathToCompare();
}
