/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.wcm.style;

import javax.annotation.Nullable;

import com.day.cq.wcm.api.components.Component;

/**
 * Useful helper methods for the WCM style feature.
 *
 * @since com.adobe.cq.wcm.style 1.0.0
 */
public final class StyleUtils {

    /**
     * Retrieves a list of allowed style HTML elements for a component.
     *
     * If no elements is defined for the component, it walks the component hierarchy.
     *
     * @return an array of allowed style HTML elements, {@code null} otherwise
     * @since com.adobe.cq.wcm.style 1.0.0
     */
    @Nullable
    public static String[] getAllowedStyleElements(@Nullable Component component) {
        if (component != null) {
            String[] styleElementNames = component.getProperties().get(StyleConstants.PN_STYLE_ELEMENTS, String[].class);
            if (styleElementNames != null) {
                return styleElementNames;
            }
            return getAllowedStyleElements(component.getSuperComponent());
        }
        return null;
    }

}
