/**
 * 
 */
package com.adobe.fontengine;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.concurrent.ConcurrentHashMap;

import com.adobe.agl.charset.CharsetICU;

public class CharsetUtil 
{
	private static ConcurrentHashMap<String, Charset> charSetMap = new ConcurrentHashMap<String, Charset>();

	public static CoderResult encodeLoop(CharBuffer input, ByteBuffer output, CharsetEncoder encoder, boolean throwExceptions) 
	throws MalformedInputException, UnmappableCharacterException
	{
		CoderResult result = null;
		try {
			result = encoder.encode(input, output, true /*end of input*/);
			if (result.isMalformed() || !result.isError())
			{
				result = encoder.flush(output);
				if (result.isError() && !result.isUnderflow())
				{
					conditionallyThrowCodingError(result);
				}
			}
			conditionallyThrowCodingError(result);
		} catch (MalformedInputException e) {
			if (throwExceptions)
			{
				throw e;
			}
		} catch (UnmappableCharacterException e) {
			if (throwExceptions)
			{
				throw e;
			}
		} finally {

		}

		return result;
	}

	public static CoderResult encodeLoopNoExceptions(CharBuffer input, ByteBuffer output, CharsetEncoder encoder)
	{
		CoderResult result = null;
		try {
			result = encodeLoop(input, output, encoder, false);
		} catch (MalformedInputException e) {
			// don't throw
		} catch (UnmappableCharacterException e) {
			// don't throw
		}
		return result;
	}

	public static CoderResult encodeLoop(CharBuffer input, ByteBuffer output, Charset charset, boolean throwExceptions) 
	throws MalformedInputException, UnmappableCharacterException
	{
		CharsetEncoder encoder = charset.newEncoder();
		return encodeLoop(input, output, encoder, throwExceptions);
	}

	public static CoderResult encodeLoopNoExceptions(CharBuffer input, ByteBuffer output, Charset charset) 
	throws MalformedInputException, UnmappableCharacterException
	{
		CharsetEncoder encoder = charset.newEncoder();
		return encodeLoopNoExceptions(input, output, encoder);
	}

	public static CoderResult decodeLoop(ByteBuffer input, CharBuffer output, CharsetDecoder decoder, boolean throwExceptions) 
	throws MalformedInputException, UnmappableCharacterException
	{
		CoderResult result = null;
		try {
			result = decoder.decode(input, output, true /*end of input*/);
			conditionallyThrowCodingError(result);
			result = decoder.flush(output);
			conditionallyThrowCodingError(result);	
			decoder.reset();
		} catch (MalformedInputException e) {
			if (throwExceptions)
			{
				throw e;
			}
		} catch (UnmappableCharacterException e) {
			if (throwExceptions)
			{
				throw e;
			}
		} finally {

		}

		return result;
	}

	public static CoderResult decodeLoopNoExceptions(ByteBuffer input, CharBuffer output, CharsetDecoder decoder) 
	{
		CoderResult result = null;
		try {
			result = decodeLoop(input, output, decoder, false);
		} catch (MalformedInputException e) {
			// don't throw
		} catch (UnmappableCharacterException e) {
			// don't throw
		}
		return result;
	}

	public static CoderResult decodeLoop(ByteBuffer input, CharBuffer output, Charset charset, boolean throwExceptions) 
	throws MalformedInputException, UnmappableCharacterException
	{
		CharsetDecoder decoder = charset.newDecoder();
		return decodeLoop(input, output, decoder, throwExceptions);
	}

	public static CoderResult decodeLoopNoExceptions(ByteBuffer input, CharBuffer output, Charset charset) 
	throws MalformedInputException, UnmappableCharacterException
	{
		CharsetDecoder decoder = charset.newDecoder();
		return decodeLoopNoExceptions(input, output, decoder);
	}

	public static void conditionallyThrowCodingError(CoderResult result) 
	throws MalformedInputException, UnmappableCharacterException 
	{
		if (result.isError())
		{
			if (result.isMalformed())
			{
				throw new MalformedInputException(result.length());
			}
			if (result.isOverflow())
			{
				//throw new Enc
			}
			if (result.isUnmappable())
			{
				throw new UnmappableCharacterException(result.length());
			}
			if (result.isUnderflow())
			{

			}
		}
	}

	/**
	 * This method is only thread-safe to the extent provided by ConcurrentHashMap.
	 */
	public static Charset forNameICU(String charsetName)
	{
		if (charsetName == null)
			return null;
		Charset charSet = charSetMap.get(charsetName);
		if (charSet == null) {
			charSet = CharsetICU.forNameICU(charsetName);
			Charset prev = charSetMap.putIfAbsent(charsetName, charSet);
			if (prev != null)
			{
				charSet = prev;
			}
		}
		return charSet;
	}
}
