/*
*
*	File: FontLoadingException.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/

package com.adobe.fontengine.font;

/**
 * Generally thrown when the data representing the font is unable to be loaded or reloaded.
 * 
 * <h4>Synchronization</h4>
 * 
 * <p>This class has the same thread safety guarantees as java.lang.Exception.</p>

 */
public class FontLoadingException extends FontException {
  
    static final long serialVersionUID = 1;

    public FontLoadingException()
    {
        super();
    }

    public FontLoadingException(Font font)
    {
        super(font);
    }


    public FontLoadingException(String message)
    {
        super(message);
    }

    public FontLoadingException(String message, Font font)
    {
        super(message, font);
    }

    public FontLoadingException(String message, Throwable cause)
    {
        super(message, cause);
    }

    public FontLoadingException(String message, Throwable cause, Font font)
    {
        super(message, cause, font);
    }

    public FontLoadingException(Throwable cause)
    {
        super(cause);
    }

    public FontLoadingException(Throwable cause, Font font)
    {
        super(cause, font);
    }
}
