/*
 * File: LineMetrics.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.font;

/** The line metrics of a font.
 * 
 * These are the values recommended by the font designer for 
 * typographic ascender, typographic descender and line gap.
 * 
 * <h4>Synchronization</h4>
 * 
 * <p>These objects are immutable.</p>
 */

final public class LineMetrics {
  public final double ascender;
  public final double descender;
  public final double linegap;
  
  public LineMetrics (double ascender, double descender, double linegap) {
    this.ascender = ascender;
    this.descender = descender;
    this.linegap = linegap;
  }
  
  public LineMetrics toEmSpace (double unitsPerEmX, double unitsPerEmY) {
  	return new LineMetrics (ascender / unitsPerEmY, descender / unitsPerEmY,
  			linegap / unitsPerEmY);
  }
  
  public LineMetrics toDesignSpace (double unitsPerEmX, double unitsPerEmY) {
  	return new LineMetrics (ascender * unitsPerEmY, descender * unitsPerEmY,
  			linegap * unitsPerEmY);
  }
  


  public boolean equals (Object o) {
    if (o == null) {
      return false; }
    if (o == this) {
      return true; }
    if (! (o instanceof LineMetrics)) {
      return false; }
    LineMetrics vm = (LineMetrics) o;
    return (vm.ascender == this.ascender 
            && vm.descender == this.descender
            && vm.linegap == this.linegap);
  }
  
  public int hashCode () {
    return (int)ascender ^ (int)descender ^ (int)linegap;
  }
  
  public String toString () {
    return "[a=" + ascender + " d=" + descender + " lg=" + linegap + "]";
  }
}
