/*
 * File: OutlineConsumer2.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2006 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is
 *      obtained from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.font;

/** Receives events for outlines.
 * 
 * Multiple outlines can be sent through this interface. The calls to 
 * this interface must follow the pattern 
 * (startOutline (startCountour (line | quadraticCurve | cubicCurve)* endCountour)* endOutline)*.
 * 
 * This interface provides two ways for the client to communicate the coordinates
 * of lines and curves: as double or as 26.6 fixed point numbers. Typically,
 * a client will use a consistent set, but there is nothing that prevents the
 * two ways to be mixed. An implementation of the interface will typically
 * convert one set to the other, as best appropriate for its purposes.
 * The class {@link OutlineConsumer2BaseImpl} provides a "filtering"
 * implementation that can help with that.
 * 
 * Regardless of the format in which the numbers are expressed, their meaning
 * (i.e. units) is not defined by this interface. It is up to the client and
 * implementation to agree on them.
 *
 */
public interface OutlineConsumer2 {
  
  void startOutline ();
    void startContour ();

      void line (double x1, double y1, double x2, double y2);
      void line (int /*26.6*/ x1, int /*26.6*/ y1, int /*26.6*/ x2, int /*26.6*/ y2);
  
      void quadraticCurve (double x1, double y1, double x2, double y2, double x3, double y3);
      void quadraticCurve (int /*26.6*/ x1, int /*26.6*/ y1, int /*26.6*/ x2, int /*26.6*/ y2, int /*26.6*/ x3, int /*26.6*/ y3);

      void cubicCurve (double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4);
      void cubicCurve (int /*26.6*/ x1, int /*26.6*/ y1, int /*26.6*/ x2, int /*26.6*/ y2, int /*26.6*/ x3, int /*26.6*/ y3, int /*26.6*/ x4, int /*26.6*/ y4);

    void endContour ();
  void endOutline ();
}
