/*
 * File: ROS.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is
 *      obtained from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.font;

/**
 * A Registry/Ordering/Supplement tuple. ROS's are explained in Tech Note 5014,
 * found here: http://partners.adobe.com/public/developer/en/font/5014.CIDFont_Spec.pdf
 * 
 * <h4> Synchronization </h4>
 * Instances of this class are immutable after creation and are therefore threadsafe.
 */
final public class ROS {
    final public String registry;
    final public String ordering;
    final public int supplement;

    public ROS(String registry, String ordering, int supplement)
    {
        this.registry = registry;
        this.ordering = ordering;
        this.supplement = supplement;
    }
    
    public String toString()
    {
    	return registry + " " + ordering + " " + Integer.toString(supplement);
    }
}
