/*
*
*	File: SubsetSimpleTrueType.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2007 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/
package com.adobe.fontengine.font;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class SubsetSimpleTrueType {
	private final int mPlatformID;		// The cmap platform ID
	private final int mPlatformSpecificID;	// The cmap platform specific ID
	private final int[] mCodePoints;	// An arbitrary list of codepoints relative to that cmap
	private final String[] mPostNames;	// An arbitrary list of POST table glyph name strings

	/**
	 * Prepare a subset object for a simple TrueType font. This consists of
	 * a SINGLE cmap and a list of codepoints relative to that cmap. The codepoints
	 * are 32-bit values because they may be Unicode codepoints. The POST table glyph
	 * names list is optional and should contain ONLY names that are required but not
	 * available in the passed cmap. These names will be compared against the font's
	 * POST table and, if there is none or the name is missing, an error is thrown.
	 * The length and order of the lists is unimportant. Duplicate entries will be
	 * removed and null entries in the POST names list are ignored.
	 */
	public SubsetSimpleTrueType(int platformID, int platformSpecificID, int[] codePoints, String[] postNames)
	{
		mPlatformID = platformID;
		mPlatformSpecificID = platformSpecificID;
		ArrayList cps = new ArrayList();
		for (int i = 0; i < codePoints.length; i++) {
			if (codePoints[i] > 0)
				cps.add(new Integer(codePoints[i]));
		}
		Collections.sort(cps);
		int lastCP = -1;
		Iterator iter = cps.iterator();
		while (iter.hasNext()) {
			int thisCP = ((Integer)iter.next()).intValue();
			if (thisCP == lastCP)
				iter.remove();
			lastCP = thisCP;
		}
		codePoints = new int[cps.size()];
		for (int i = 0; i < cps.size(); i++)
			codePoints[i] = ((Integer)cps.get(i)).intValue();
		mCodePoints = codePoints;
		mPostNames = postNames;
	}

	public int getPlatformID()
	{
		return mPlatformID;
	}

	public int getPlatformSpecificID()
	{
		return mPlatformSpecificID;
	}

	public int[] getCodePoints()
	{
		return mCodePoints;
	}

	public String[] getPostNames()
	{
		return mPostNames;
	}
}
