/*
 * File: UnderlineMetrics.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is
 *      obtained from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.font;

/** The metrics for underlining.
 * 
 * <h4>Synchronization</h4>
 * 
 * <p>These objects are immutable.</p>
 */

final public class UnderlineMetrics {
  public final double position;
  public final double thickness;
  
  public UnderlineMetrics (double position, double thickness) {
    this.position = position;
    this.thickness = thickness;
  }
  
  public UnderlineMetrics toEmSpace (double unitsPerEmX, double unitsPerEmY) {
  	return new UnderlineMetrics (position / unitsPerEmY, thickness / unitsPerEmY);
  }
  
  public UnderlineMetrics toDesignSpace (double unitsPerEmX, double unitsPerEmY) {
  	return new UnderlineMetrics (position * unitsPerEmY, thickness * unitsPerEmY);
  }
  

  public boolean equals (Object o) {
    if (o == null) {
      return false; }
    if (o == this) {
      return true; }
    if (! (o instanceof UnderlineMetrics)) {
      return false; }
    UnderlineMetrics vm = (UnderlineMetrics) o;
    return (vm.position == this.position 
            && vm.thickness == this.thickness);
  }
  
  public int hashCode () {
    return (int)position ^ (int)thickness;
  }
  
  public String toString () {
    return "[p=" + position + " t=" + thickness + "]";
  }
}
