/*
*
*	File: Header.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2004-2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/

package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CFFByteArray.CFFByteArrayBuilder;

/** Represents the header of a CFFFontSet.
 */
final class Header {
  
  /* Our strategy is to just keep our thumb on the underlying bytes,
   * and to interpret them when needed. */
  
  /** The container for our bytes. */
  protected final CFFByteArray data;
  /** The offset of our bytes in <code>data</code>. */
  protected final int offset;
  
  
  /** Construct a <code>Header</code> from a <code>CFFByteArray</code>.
   * @param data the CFFByteArray to get data from
   * @param offset the offset of the first byte in <code>data</code>
   */
  protected Header (CFFByteArray data, int offset)
      throws InvalidFontException, UnsupportedFontException {

    this.data = data;
    this.offset = offset;
  }
  
  /** Return the major version.
   */
  public int getMajorVersion () throws InvalidFontException {
    return data.getcard8 (0);
  }
  
  /** Return the minor version.
   */
  public int getMinorversion () throws InvalidFontException {
    return data.getcard8 (1);
  }
  
  /** Return the size of the header, in bytes.
   */
  public int size () throws InvalidFontException {
    return data.getcard8 (2);
  }
  
  
  // Experimental
  static void toBinary (CFFByteArrayBuilder b) {
    b.addCard8 (1);
    b.addCard8 (0);
    b.addCard8 (4);
    b.addCard8 (4);  // offSize, not used?
  }
}
