/*
 *
 *	File: Type2CStringOps.java
 *
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.font.cff;

/**
 * Namespace containing operators that can be found in type2 charstrings.
 * 
 * <h4>
 * Synchronization
 * </h4>
 * This class has no instance data and no mutable static data. It is therefore
 * threadsafe.
 */
final class Type2CStringOps {
  private Type2CStringOps() {}

  // 1 byte operators (or first byte operators)
  static final int HSTEM = 1;
  static final int VSTEM = 3;
  static final int VMOVETO = 4;
  static final int RLINETO = 5;
  static final int HLINETO = 6;
  static final int VLINETO = 7;
  static final int RRCURVETO = 8;
  static final int CALLSUBR = 10;
  static final int RETURN = 11;
  static final int ESCAPE = 12;
  static final int ENDCHAR = 14;
  static final int HSTEMHM = 18;
  static final int HINTMASK = 19;
  static final int CNTRMASK = 20;
  static final int RMOVETO = 21;
  static final int HMOVETO = 22;
  static final int VSTEMHM = 23;
  static final int RCURVELINE = 24;
  static final int RLINECURVE = 25;
  static final int VVCURVETO = 26;
  static final int HHCURVETO = 27;
  static final int SHORTINT = 28;
  static final int CALLGSUBR = 29;
  static final int VHCURVETO = 30;
  static final int HVCURVETO = 31;
  static final int FIVE_BYTE = 255;

  // 2 byte operators
  static final int ESC_DOTSECTION = 0;
  static final int ESC_AND = 3;
  static final int ESC_OR = 4;
  static final int ESC_NOT = 5;
  static final int ESC_ABS = 9;
  static final int ESC_ADD = 10;
  static final int ESC_SUB = 11;
  static final int ESC_DIV = 12;
  static final int ESC_NEG = 14;
  static final int ESC_EQ = 15;
  static final int ESC_DROP = 18;
  static final int ESC_PUT = 20;
  static final int ESC_GET = 21;
  static final int ESC_IFELSE = 22;
  static final int ESC_RANDOM = 23;
  static final int ESC_MUL = 24;
  static final int ESC_SQRT = 26;
  static final int ESC_DUP = 27;
  static final int ESC_EXCH = 28;
  static final int ESC_INDEX = 29;
  static final int ESC_ROLL = 30;
  static final int ESC_HFLEX = 34;
  static final int ESC_FLEX = 35;
  static final int ESC_HFLEX1 = 36;
  static final int ESC_FLEX1 = 37;

  // an undocumented operator that says that the glyph should 
  // use global coloring. If no countermask is present in the glyph,
  // than the presence of this operator will activate 2-pass 
  // global coloring regardless of the font's language group.
  static final int ESC_GLOBALCOLORME = 38;
}
