/*
*
*	File: Type2ConsumerDefaultImpl.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2004-2006 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/

package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.InvalidFontException;

/** Empty implementation of Type2Consumer, useful as a base class
 * for an actual implementation.
 */
public class Type2ConsumerDefaultImpl implements Type2Consumer {

  public void abs (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void add (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void and (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void callgsubr (double[] stack, int stackDepth, int subr) {
    // default implementation, do nothing
  }

  public void callsubr (double[] stack, int stackDepth, int subr) {
    // default implementation, do nothing
  }

  public void cntrmask (double[] stack, int stackDepth, CFFByteArray data,
                        int offset, int length) throws InvalidFontException {
    // default implementation, do nothing
  }

  public void div (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void drop (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void dup (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void endchar (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void eq (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void exch (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void flex (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void flex1 (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void real (double[] stack, int stackDepth, double a) {
    // default implementation, do nothing
  }

  public void get (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void hflex (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void hflex1 (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void hhcurveto (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void hintmask (double stack[], int stackDepth, 
                        CFFByteArray data, int offset, int length) throws InvalidFontException{
    // default implementation, do nothing
  }

  public void hlineto (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void hmoveto (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }
  
  public void moveto (double[] stack, int stackDepth) {
      // default implementation, do nothing.
  }

  public void hstem (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void hstemhm (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void hvcurveto (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void ifelse (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void implicit_vstemhm (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void index (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void integer (double[] stack, int stackDepth, int i) {
    // default implementation, do nothing
  }

  public void mul (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void neg (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void not (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void or (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void put (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void random (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void rcurveline (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void return_op (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void rlinecurve (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void rlineto (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void rmoveto (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void roll (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void rrcurveto (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void sqrt (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void sub (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void vhcurveto (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void vlineto (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void vmoveto (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void vstem (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }
 
  public void vstemhm (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }

  public void vvcurveto (double[] stack, int stackDepth) {
    // default implementation, do nothing
  }
  
  public boolean width (double w) {
    // default implementation, do nothing, continue parsing
    return true;
  }
  
  public boolean seac(double[] stack, int stackDepth) {
    // default implementation. Recursively parse.
    return true;
  }
  
  public void globalColorMe (double[] stack, int stackDepth) {
    // do nothing
  }
}
