/*
 *
 *	File: Type2GlyphBBoxCalculator.java
 *
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.GlyphBBoxCalculator;
import com.adobe.fontengine.font.GlyphBBoxOutlineConsumer;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.FontData;

/**
 * Calculates an unhinted glyph bounding box for a type2 glyph description
 * at a specified size.
 * 
 * <p>Instances of this class can be reused across multiple fonts and glyphs.</p>
 * 
 * <h4>Synchronization</h4>
 * 
 * This class is synchronized. Only one thread will be allowed into the calculateBBox
 * method at a time.
 */
final public class Type2GlyphBBoxCalculator implements GlyphBBoxCalculator {
  private final GlyphBBoxOutlineConsumer consumer; 
  private final Type2OutlineParser parser = new Type2OutlineParser(false);

  public Type2GlyphBBoxCalculator(Matrix finalMatrix) {
    consumer = new GlyphBBoxOutlineConsumer(finalMatrix);
  }

  /**
   * Calculates the bounding box for a glyph.
   * @param font the font containing the glyph
   * @param glyphID the glyph to be calculated
   * @return the unhinted bounding box for the glyph
   * @throws InvalidFontException thrown when a glyph description is malformed.
   */
  public synchronized Rect calculateBBox(FontData font, int glyphID) 
  throws InvalidFontException, UnsupportedFontException { 
    consumer.reset(); 
    ((CFFFont)font).getOutline(glyphID, parser, consumer);
    return consumer.getBBox();
  }
}
