package com.adobe.fontengine.font.mac;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;	// This is "linked" to assure iteration order for font cache testing
import java.util.Set;

import com.adobe.internal.io.ExtendedDataInputStream;
import com.adobe.internal.mac.resource.BasicResourceHandler;
import com.adobe.internal.mac.resource.ResourceParser.ResourceEntry;

public class FONDResourceHandler extends BasicResourceHandler 
{
	public static class Association
	{
		private static final int STYLE_BOLD			= 0x01;
		private static final int STYLE_ITALIC		= 0x02;
//		private static final int STYLE_UNDERLINE	= 0x04;
//		private static final int STYLE_OUTLINE		= 0x08;
//		private static final int STYLE_SHADOW		= 0x10;
//		private static final int STYLE_CONDENSE		= 0x20;
//		private static final int STYLE_EXTEND		= 0x40;
//		private static final int STYLE_MASK			= 0x7f;

		private String name;
		private int size;
		private int style;
		private int fontID;
		private int script;
		private int fondID;

		private Association(int fondID, int fontID, String name, int script, int size, int style)
		{
			this.fondID = fondID;
			this.size = size;
			this.style = style;
			this.fontID = fontID;
			this.name = name;
			this.script = script;
		}

		public int getFondID()
		{
			return this.fondID;
		}
		
		public int getSize()
		{
			return this.size;
		}

		public int getStyle()
		{
			return this.style;
		}

		public boolean isBold()
		{
			return (this.style & STYLE_BOLD) == STYLE_BOLD;
		}

		public boolean isItalic()
		{
			return (this.style & STYLE_ITALIC) == STYLE_ITALIC;
		}

		public int getFontID()
		{
			return this.fontID;
		}

		public String getName()
		{
			return this.name;
		}

		public int getScriptCode()
		{
			return this.script;
		}
		
		public String toString()
		{
			StringBuffer sb = new StringBuffer();
			sb.append("fondID = " + this.fondID);
			sb.append("fontID = " + this.fontID);
			sb.append(", name = " + this.name);
			sb.append(", size = " + this.size);
			sb.append(", style = " + this.style);
			sb.append(" (bold = " + this.isBold());
			sb.append(", italic = " + this.isItalic() + ")");
			return sb.toString();
		}
	}

	private static final byte[] FOND = {'F', 'O', 'N', 'D'};
	private static final long ASSOCIATION_TABLE_OFFSET = 52;

	private Set<Association> associations;

	public FONDResourceHandler() 
	{
		super(FOND);
		this.associations = new LinkedHashSet<Association>();	// This is "linked" to assure iteration order for font cache testing
	}

	public void handleResource(ResourceEntry entry,	long length, InputStream stream) 
	{
		try {
//			System.out.println("@@@ Resource Handler Plugin for type " + new String(handlerType));
//			System.out.println("\ttype = " + new String(type));
//			System.out.println("\tattributes = " + attributes);
//			System.out.println("\tname = " + name);
//			System.out.println("\tlength = " + length);

			ExtendedDataInputStream dis = new ExtendedDataInputStream(stream);
			dis.skipFully(ASSOCIATION_TABLE_OFFSET);
			int numberOfAssociations = dis.readUnsignedShort();
			for (int associationIndex = 0; associationIndex <= numberOfAssociations; associationIndex++)
			{
				int size = dis.readUnsignedShort();
				int style = dis.readUnsignedShort();
				int fontID = dis.readUnsignedShort();
				Association association = new Association(entry.getID(), fontID, entry.getName(), entry.getScriptCode(), size, style);
				this.associations.add(association);
			}
		} catch (IOException e) {
		}
	}

	public Set<Association> getAssociations()
	{
		return this.associations;
	}
}
