/**
 * 
 */
package com.adobe.fontengine.font.opentype;

import java.util.Map;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.LookupTableHarvester.CoverageLookupHarvester;

class ContextFormat1Harvester implements CoverageLookupHarvester {
	  private Map lookups;
	  private final LookupTableHarvester harvester;
	  private final boolean continueIterating;
	  
	  ContextFormat1Harvester(LookupTableHarvester harvester, Map lookups, boolean continueIteratingWhenLookupApplies) {
		  this.lookups = lookups;
		  this.harvester = harvester;
		  this.continueIterating = continueIteratingWhenLookupApplies;
	  }
	  
	  public boolean lookupApplies(int coverageGlyph, int stOffset, int coverageIndex, Subset gids) throws InvalidFontException, UnsupportedFontException {
		  
		  int subruleSetOffset = harvester.lookupTable.data.getOffset (stOffset, 6 + 2*coverageIndex);
		  int subruleCount = harvester.lookupTable.data.getuint16(subruleSetOffset);
		  boolean applies = false;
		  for (int i = 0; i < subruleCount; i++)
		  {
			  int subruleOffset = harvester.lookupTable.data.getOffset(subruleSetOffset, 2 + 2*i);
			  int j;
			  int glyphCount = harvester.lookupTable.data.getuint16(subruleOffset);
			  for (j = 0; j < glyphCount-1; j++) {
				  int gid = harvester.lookupTable.data.getuint16(subruleOffset + 4 + 2*j);
				  if (gids.getExistingSubsetGid(gid) == -1)
					  break;
			  }
			  if (j == glyphCount-1) {
				  int lookupCount = harvester.lookupTable.data.getuint16(subruleOffset+2);
				  for (j = 0; j < lookupCount; j++)
				  {
					  int lookupIndex = harvester.lookupTable.data.getuint16(subruleOffset + 4 + 2*(glyphCount-1) + 4*j + 2);
					  // Note that this is a little bit loose. If we wanted the tightest set, we'd
					  // only harvest on the glyphs that this lookup applies to. However, I'll work on the
					  // assumption that if this sublookup applies to other glyphs in 'gids', then there will be
					  // a path that gets us there in most fonts, so we'll want it eventually anyway.(That's a
					  // good sounding justification for matching cooltype's behavior anyway...)
					  harvester.harvest(gids, lookupIndex, lookups);
				  }
				  applies = true;
			  }
		  }
		  
		  return applies;
	  }
	  
	  public boolean keepGoing() {
		return continueIterating;
	}
  }