/*
*
*	File: LocaRaw.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2004-2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/

package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;

/** Gives access to a raw 'loca' table.
*
* <p>'loca' tables do not stand one their own and are not useful
* on their own; see {@link com.adobe.fontengine.font.opentype.Glyf}
*  for a wrapping which corrects that.</p>
* 
* <h4>Version handling</h4>
* 
* <p>'loca' tables are not versioned.</p>
*
* <h4>Synchronization</h4>
* 
* <p>Like all tables, these objects are immutable.</p> 
**/

final class LocaRaw extends Table {
  
  protected LocaRaw (FontByteArray buffer) 
  throws java.io.IOException, InvalidFontException, UnsupportedFontException {
    super (buffer);
  }
  
  /** Get the offset in the 'glyf' table of the glyph 'gid'. */
  public int getGlyphLocation (int gid, int indexToLocFormat)
  throws UnsupportedFontException, InvalidFontException{

    if (indexToLocFormat == 0) {
      return this.data.getuint16 (gid * 2) * 2; }
    else {
      return this.data.getuint32asint (gid * 4,
                              "loca index too big"); }
  }
}
