/*
 * File: OTSelector.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.inlineformatting.AttributedRun;

/** Determine if a feature can be applied at some positions.
 * 
 * This is both the complete implementation for a selector
 * that always return true (on a single position), returns
 * true on multiple position if it returns true on each single position,
 * and the base class for more complicated selectors.
 */
public class OTSelector {

  public boolean isApplied (AttributedRun run, int position) {
    return true;
  }
  
  public boolean isApplied (AttributedRun run, int from, int to) {
    for (int position = from; position <= to; position++) {
      if (! isApplied (run, position)) {
        return false; }}
    return true; 
  }
  
  public boolean isApplied (AttributedRun run, int[] positions) {
    for (int i = 0; i < positions.length; i++) {
      if (! isApplied (run, positions [i])) {
        return false; }}
    return true;
  }
}
