/*
 * File: OTSelectors.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.inlineformatting.LigatureLevel;

/** Common OTSelector objects. */
public class OTSelectors {
  
  private OTSelectors () {
    // this class is just a namespace for common selectors
  }
  
  public static final OTSelector everywhere = new OTSelectorEverywhere ();
  
  public static final OTSelector minimumLigatures
    = new OTSelectorAtLigatureLevel (LigatureLevel.MINIMUM);
  
  public static final OTSelector commonLigatures
    = new OTSelectorAtLigatureLevel (LigatureLevel.COMMON);
  
  public static final OTSelector uncommonLigatures
    = new OTSelectorAtLigatureLevel (LigatureLevel.UNCOMMON);
  
  public static final OTSelector exoticLigatures
    = new OTSelectorAtLigatureLevel (LigatureLevel.EXOTIC);
}
