/*
*
*	File: OTSubset.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2004-2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/

package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.SubsetDefaultImpl;
import com.adobe.fontengine.font.UnsupportedFontException;

final public class OTSubset extends SubsetDefaultImpl {
  
  final OpenTypeFont font;
  final boolean targettingCFF;

  public OTSubset (OpenTypeFont font, boolean targettingCFF) 
      throws UnsupportedFontException, InvalidFontException {
    
    super (font.getNumGlyphs (), true);
    
    this.font = font;
    this.targettingCFF = targettingCFF;
    
    if (!targettingCFF) {
      getSubsetGid (0);
      getSubsetGid (1);
      getSubsetGid (2);
      getSubsetGid (3); } 
    else {
      getSubsetGid (0); }
  }
  
  protected void pullComponentGlyphs (int fullGid) 
  throws UnsupportedFontException, InvalidFontException {
    if (font.glyf != null && !targettingCFF) {
      font.glyf.pullComponentGlyphs (this, fullGid); }
  }
  
  public String toString()
  {
	  StringBuffer buff = new StringBuffer();
	  for (int i = 0; i < getNumGlyphs(); i++)
	  {
		  buff.append(getFullGid(i) + " -> " + i + "; " );
	  }
	  
	  return buff.toString();
  }
}
