/*
 * File: OpticalSizeData.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.font.opentype;

/** Represents the optical size data for an OpenType font.
 */
final public class OpticalSizeData {
  public final int designSize;  // in decipoints
  public final int subfamilyId;
  public final int nameId;
  public final int minSize;  // in decipoints
  public final int maxSize;   // in decipoints
  
  public OpticalSizeData (int designSize, int subfamilyId, int nameId,
                          int minSize, int maxSize) {
    this.designSize = designSize;
    this.subfamilyId = subfamilyId;
    this.nameId = nameId;
    this.minSize = minSize;
    this.maxSize = maxSize; 
  }
  
}
