/*
 * File: TTPoint.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2006 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is
 *      obtained from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.math.F26Dot6;
import com.adobe.fontengine.math.F26Dot6Vector;
import com.adobe.fontengine.math.F32Dot0Vector;

/** Represents a point in a TrueType outline.
 */

public final class TTPoint implements Cloneable {
  public boolean onCurve;
  public F32Dot0Vector unscaled;
  public F26Dot6Vector original;
  public F26Dot6Vector unhinted;
  public F26Dot6Vector hinted;
  public boolean touchedX;
  public boolean touchedY;

  public TTPoint (int x, int y, boolean onCurve) {
    unscaled = new F32Dot0Vector ();
    unscaled.x = x;
    unscaled.y = y;
    original = new F26Dot6Vector ();
    unhinted = new F26Dot6Vector ();
    hinted = new F26Dot6Vector ();
    touchedX = false;
    touchedY = false;
    this.onCurve = onCurve;
  }
  
  public void scale (int unitsPerEm, Matrix em2px) {
    double xInEm = unscaled.x / (double) unitsPerEm;
    double yInEm = unscaled.y / (double) unitsPerEm;
    unhinted.x = F26Dot6.fromDouble (em2px.applyToXYGetX (xInEm, yInEm));
    unhinted.y = F26Dot6.fromDouble (em2px.applyToXYGetY (xInEm, yInEm));
    original.x = unhinted.x;
    original.y = unhinted.y;
    hinted.x = unhinted.x;
    hinted.y = unhinted.y;
    touchedX = false;
    touchedY = false;
  }
  
  public boolean touched (boolean x) {
    if (x) {
      return touchedX; }
    else {
      return touchedY; }
  }
  
  public Object clone () {
    TTPoint p = new TTPoint (unscaled.x, unscaled.y, onCurve);
    p.original.x = original.x;
    p.original.y = original.y;
    p.hinted.x = hinted.x;
    p.hinted.y = hinted.y;
    p.unhinted.x = unhinted.x;
    p.unhinted.y = unhinted.y;
    p.touchedX = touchedX;
    p.touchedY = touchedY;  
    return p;
  }
  
  public String toString () {
    return "u=" + unscaled + " o=" + unhinted + " c=" + hinted 
      + " on=" + onCurve 
      + " t=" + (touchedX ? "Y" : "N") + (touchedY ? "Y" : "N");
  }
}