/*
 *
 *	File: SeacPhase.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 * 
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.font.postscript;

/**
 * An "enum" that describes the phases of seac that a type1 or type2 outline parser can be in.
 *
 * <h4>Synchronization</h4>
 * 
 * This class is immutable after contruction and contains no mutable
 * static data. It is therefore threadsafe.
 */
final public class SeacPhase {
	private SeacPhase(){}
	
	/** No seac has been seen in the current glyph */
	final public static SeacPhase seacNone = new SeacPhase();
	
	/** The base glyph is being parsed */
	final public static SeacPhase seacBase = new SeacPhase();
	
	/** The accent glyph is being parsed and the first moveto has not been seen */
	final public static SeacPhase seacAccentPreMove = new SeacPhase();
	
	/** The accent glyph is being parsed and the first moveto has been seen */
	final public static SeacPhase seacAccentPostMove = new SeacPhase();		
}