/*
 *
 *	File: BinaryEexecReader.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 * 
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.font.type1;

import java.io.IOException;

import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.postscript.Reader;

/**
 * A filter to decrypt binary eexec.
 *
 * <h4>Synchronization</h4>
 * 
 * This class is NOT threadsafe. Multiple instances can safely
 * coexist without threadsafety issues, but each must only be accessed 
 * from one thread (or must be guarded by the client).
 */
final class BinaryEexecReader implements Reader {        

    private int lastRead;
    private int lastCipher;
    private int cipherR;

    BinaryEexecReader() {
        cipherR = 55665;
    }
    
    public int read(FontInputStream stream)
    	throws IOException, InvalidFontException
    {
        int retVal;
        lastRead = stream.read();
        
        if (lastRead == -1)
            throw new InvalidFontException("unexpected end of file");
        
        lastCipher = cipherR;
        retVal = decryptByte((byte)lastRead);
        
        return retVal;
    }
    
    public void unreadLast(FontInputStream stream)
    	throws IOException
    {
        cipherR = lastCipher;    
        stream.unread(lastRead);
    }

	
	public int decryptByte(byte inputByte)
    {
        byte dst = (byte)(inputByte ^ (cipherR>>8));
		cipherR = (((inputByte & 0xff) + cipherR)*52845 + 22719) & 0xffff;
		
		return dst & 0xff;    
    }
	
	int decryptBuffer(byte[] buffer, int numBytesToDecrypt)
	{
	    int dest=0;
	        
	    for (int i = 0; i < numBytesToDecrypt; ++i)
	    {
	        buffer[dest++] = (byte)decryptByte(buffer[i]);
	    }
	        
	    return dest;
	}
}